/*==========================================================================
 * Module Name : console_debug.c
 * Purpose     : 
 * Author      : 
 * Date        : 
 * Notes       :
 * $Log$
 *==========================================================================
 */
 
/* INCLUDE FILE DECLARATIONS */
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/sockios.h>
#include <stdlib.h>
#include <ctype.h>
#if NET_INTERFACE == INTERFACE_SCAN
#include <ifaddrs.h>
#endif
#include "ioctl.h"

/* STATIC VARIABLE DECLARATIONS */
#define ASIX_IOCTL_VERSION		"ASIX Linux IOCTL Tool v1.0.0"

/* LOCAL SUBPROGRAM DECLARATIONS */
const char help_str1[] =
"./ioctl help [command]\n"
"    -- command description\n";
const char help_str2[] =
"        [command] - Display usage of specified command\n";

const char usbcommand_str1[] =
"./ioctl usb [ops] [cmd] [value] [index] [size] [file]\n"
"    -- ASIX USB USB Command Tool\n";
const char usbcommand_str2[] =
"        [ops]     - 0: Read,  1: Write\n"
"        [cmd]     - USB Command (0 - 0xFF)\n"
"        [value]   - USB wvalue (0 - 0xFFFF)\n"
"        [index]   - USB windex (0 - 0xFFFF)\n"
"        [size]    - USB wlength (1 - 4)\n"
"        [file]    - Data (0 - 0xFFFFFFFF)\n";

/* EXPORTED SUBPROGRAM SPECIFICATIONS */
void help_func (struct ax_command_info *info);
void usbcommand_func(struct ax_command_info *info);

/* TYPE DECLARATIONS */
struct _command_list asix_cmd_list[] = {
	{	"help",
		AX_SIGNATURE,
		help_func,
		help_str1,
		help_str2
	},
	{	"usb",
		AX_USB_COMMAND,
		usbcommand_func,
		usbcommand_str1,
		usbcommand_str2
	},
	{NULL},
};

/* LOCAL SUBPROGRAM BODIES */
static void show_usage(void)
{
	int i;
	printf ("Usage:\n");
	for (i = 0; asix_cmd_list[i].cmd != NULL; i++)
		printf ("%s\n", asix_cmd_list[i].help_ins);
}

static unsigned long STR_TO_U32(const char *cp,char **endp,unsigned int base)
{
	unsigned long result = 0,value;

	if (*cp == '0') {
		cp++;
		if ((*cp == 'x') && isxdigit(cp[1])) {
			base = 16;
			cp++;
		}
		if (!base) {
			base = 8;
		}
	}
	if (!base) {
		base = 10;
	}
	while (isxdigit(*cp) && (value = isdigit(*cp) ? *cp-'0' : (islower(*cp)
	    ? toupper(*cp) : *cp)-'A'+10) < base) {
		result = result*base + value;
		cp++;
	}
	if (endp)
		*endp = (char *)cp;

	return result;
}

void help_func (struct ax_command_info *info)
{
	int i;

	if (info->argv[2] == NULL) {
		for(i=0; asix_cmd_list[i].cmd != NULL; i++) {
			printf ("%s%s\n",
				asix_cmd_list[i].help_ins,
				asix_cmd_list[i].help_desc);
		}
	}

	for (i = 0; asix_cmd_list[i].cmd != NULL; i++)
	{
		if (strncmp(info->argv[1],
			    asix_cmd_list[i].cmd,
			    strlen(asix_cmd_list[i].cmd)) == 0 ) {
			printf ("%s%s\n",
				asix_cmd_list[i].help_ins,
				asix_cmd_list[i].help_desc);
			return;
		}
	}

}

void usbcommand_func(struct ax_command_info *info)
{
	struct ifreq *ifr = (struct ifreq *)info->ifr;
	AX_IOCTL_COMMAND ioctl_cmd;
	unsigned char	ops;
	unsigned char	cmd;
	unsigned short	value;
	unsigned short	index;
	unsigned short	size;
	unsigned long	data;
	int i;

	if (info->argc != 8) {
		for(i=0; asix_cmd_list[i].cmd != NULL; i++) {
			if (strncmp(info->argv[1], asix_cmd_list[i].cmd, 
					strlen(asix_cmd_list[i].cmd)) == 0 ) {
				printf ("%s%s\n", asix_cmd_list[i].help_ins, 
						asix_cmd_list[i].help_desc);
				return;
			}
		}
	}

	ops = STR_TO_U32(info->argv[2], NULL, 0);
	cmd = STR_TO_U32(info->argv[3], NULL, 0);
	value = STR_TO_U32(info->argv[4], NULL, 0);
	type = STR_TO_U32(info->argv[2], NULL, 0);
	wLen = STR_TO_U32(info->argv[4], NULL, 0) / 2;

	if ((type > 1) || ((type==0) && (wLen > 256)) || ((type==1) && (wLen > 32))) {
		for(i=0; asix_cmd_list[i].cmd != NULL; i++) {
			if (strncmp(info->argv[1], asix_cmd_list[i].cmd, 
					strlen(asix_cmd_list[i].cmd)) == 0 ) {
				printf ("%s%s\n", asix_cmd_list[i].help_ins, 
						asix_cmd_list[i].help_desc);
				return;
			}
		}
	}

	pFile = fopen(info->argv[3],"w");
	if (pFile == NULL) {
		printf("fail to open %s file\n", info->argv[3]);
		free(buf);
		return;
	}

	buf = (unsigned short *)malloc(sizeof(unsigned short) * wLen);

	ioctl_cmd.ioctl_cmd = info->ioctl_cmd;
	ioctl_cmd.size = wLen;
	ioctl_cmd.buf = buf;
	ioctl_cmd.type = type;
	ioctl_cmd.delay = 0;

	ifr->ifr_data = (caddr_t)&ioctl_cmd;

	if (ioctl(info->inet_sock, AX_PRIVATE, ifr) < 0) {
		perror("ioctl");
		free(buf);
		fclose(pFile);
		return;
	}		

	for (i = 0; i < wLen / 8; i++) {
		int j = 8 * i;
		snprintf(str_buf, 50,
				 "%04x %04x %04x %04x %04x %04x "
				 "%04x %04x\n", 
				 *(buf + j + 0), *(buf + j + 1),
				 *(buf + j + 2), *(buf + j + 3),
				 *(buf + j + 4), *(buf + j + 5),
				 *(buf + j + 6), *(buf + j + 7));

		fputs(str_buf, pFile);
	}

	free(buf);
	fclose(pFile);
	printf("read completely\n");
*/
	return;
}

/* EXPORTED SUBPROGRAM BODIES */
int main(int argc, char **argv)
{
	int inet_sock;
	struct ifreq ifr;
	char buf[0xff];
	struct ax_command_info info;
	unsigned char i;
	char	input;
	unsigned char count = 0;
	int fd, console;
	const unsigned char length = sizeof(char);
	AX_IOCTL_COMMAND ioctl_cmd;
#if NET_INTERFACE == INTERFACE_SCAN
	struct ifaddrs *addrs, *tmp;
	unsigned char	dev_exist;
#endif

	if (argc < 2) {
		show_usage();
		return 0;
	}

	inet_sock = socket(AF_INET, SOCK_DGRAM, 0);
#if NET_INTERFACE == INTERFACE_SCAN
	/* Get Device */
	getifaddrs(&addrs);
	tmp = addrs;
	dev_exist = 0;

	while (tmp) {
		memset (&ioctl_cmd, 0, sizeof (AX_IOCTL_COMMAND));
		ioctl_cmd.ioctl_cmd = AX_SIGNATURE;
		// get network interface name
		sprintf (ifr.ifr_name, "%s", tmp->ifa_name);

		ifr.ifr_data = (caddr_t)&ioctl_cmd;
		tmp = tmp->ifa_next;


		if (ioctl (inet_sock, AX_PRIVATE, &ifr) < 0)
			continue;
		
		
		if (strncmp (ioctl_cmd.sig, AX88179_DRV_NAME, strlen(AX88179_DRV_NAME)) == 0 ) {
			dev_exist = 1;
			break;
		}
		
		if (strncmp (ioctl_cmd.sig, AX88179A_DRV_NAME, strlen(AX88179A_DRV_NAME)) == 0 ) {
			dev_exist = 1;
			break;
		}
	}			
	}

	freeifaddrs(addrs);

	if (dev_exist == 0) {
		printf ("No ASIX device found\n");
		return 0;
	}
#else	
	for (i = 0; i < 255; i++) {

		memset (&ioctl_cmd, 0, sizeof (AX_IOCTL_COMMAND));
		ioctl_cmd.ioctl_cmd = AX_SIGNATURE;

		sprintf (ifr.ifr_name, "eth%d", i);
		
		ifr.ifr_data = (caddr_t)&ioctl_cmd;

		if (ioctl (inet_sock, AX_PRIVATE, &ifr) < 0)
			continue;

		if (strncmp (ioctl_cmd.sig, AX88179_DRV_NAME, strlen(AX88179_DRV_NAME)) == 0 )
			break;
			
		if (strncmp (ioctl_cmd.sig, AX88179A_DRV_NAME, strlen(AX88179A_DRV_NAME)) == 0 )
			break;
	}

	if (i == 255) {
		printf ("No ASIX device found\n");
		return 0;
	}
#endif
	for(i=0; asix_cmd_list[i].cmd != NULL; i++)
	{
		if (strncmp(argv[1], asix_cmd_list[i].cmd, strlen(asix_cmd_list[i].cmd)) == 0 ) {
			info.help_ins = asix_cmd_list[i].help_ins;
			info.help_desc = asix_cmd_list[i].help_desc;
			info.ifr = &ifr;
			info.argc = argc;
			info.argv = argv;
			info.inet_sock = inet_sock;
			info.ioctl_cmd = asix_cmd_list[i].ioctl_cmd;
			(asix_cmd_list[i].OptFunc)(&info);
			return 0;
		}
	}
	printf ("Wrong command\n");

	return 0;
}

