#ifndef __ASIX_MAIN_H
#define __ASIX_MAIN_H

#include <crypto/internal/skcipher.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/mii.h>
#include <linux/ethtool.h>
#include <linux/usb.h>
#include <linux/crc32.h>
#include <linux/if_vlan.h>
#include <linux/uaccess.h>
#include <linux/list.h>
#include <linux/ip.h>
#include <linux/ipv6.h>
#include <net/ip6_checksum.h>
#include <linux/usb/cdc.h>
#include <linux/suspend.h>
#include <linux/pm_runtime.h>
#include <linux/init.h>
#include <linux/in.h>
#include <linux/mdio.h>
#include <linux/timer.h>
#include <uapi/linux/mdio.h>
#include <linux/version.h>
#include "ax_common.h"

#ifndef smp_mb__before_atomic
#define smp_mb__before_atomic()			smp_mb()
#endif

#ifndef smp_mb__after_atomic
#define smp_mb__after_atomic()			smp_mb()
#endif
#define napi_alloc_skb(napi, length)		netdev_alloc_skb_ip_align(netdev,length)
#define napi_complete_done(n, d)		napi_complete(n)

#define AX88179_MAX_TX		4
#define AX88179_MAX_RX		10
#define AX88179_BUF_TX_SIZE	(81 * 1024)
#define AX_GSO_DEFAULT_SIZE	(16 * 1024)
#define INTBUFSIZE		8
#define TX_ALIGN		4
#define RX_ALIGN		8
#define TX_CASECADES_SIZE	(16 * 1024)

#define AX_TX_HEADER_LEN	8

#define AX_TX_TIMEOUT		(5 * HZ)

/*
 *GMII register definitions
 */
#define GMII_PHY_CONTROL			0x00	/* control reg */
	/* Bit definitions: GMII Control */
	#define GMII_CONTROL_RESET		0x8000	/* reset bit in control reg */
	#define GMII_CONTROL_LOOPBACK		0x4000	/* loopback bit in control reg */
	#define GMII_CONTROL_10MB		0x0000	/* 10 Mbit */
	#define GMII_CONTROL_100MB		0x2000	/* 100Mbit */
	#define GMII_CONTROL_1000MB		0x0040	/* 1000Mbit */
	#define GMII_CONTROL_SPEED_BITS		0x2040	/* speed bit mask */
	#define GMII_CONTROL_ENABLE_AUTO	0x1000	/* autonegotiate enable */
	#define GMII_CONTROL_POWER_DOWN		0x0800
	#define GMII_CONTROL_ISOLATE		0x0400	/* islolate bit */
	#define GMII_CONTROL_START_AUTO		0x0200	/* restart autonegotiate */
	#define GMII_CONTROL_FULL_DUPLEX	0x0100

#define GMII_PHY_STATUS				0x01	/* status reg */
	/* Bit definitions: GMII Status */
	#define GMII_STATUS_100MB_MASK		0xE000	/* any of these indicate 100 Mbit */
	#define GMII_STATUS_10MB_MASK		0x1800	/* either of these indicate 10 Mbit */
	#define GMII_STATUS_AUTO_DONE		0x0020	/* auto negotiation complete */
	#define GMII_STATUS_AUTO		0x0008	/* auto negotiation is available */
	#define GMII_STATUS_LINK_UP		0x0004	/* link status bit */
	#define GMII_STATUS_EXTENDED		0x0001	/* extended regs exist */
	#define GMII_STATUS_100T4		0x8000	/* capable of 100BT4 */
	#define GMII_STATUS_100TXFD		0x4000	/* capable of 100BTX full duplex */
	#define GMII_STATUS_100TX		0x2000	/* capable of 100BTX */
	#define GMII_STATUS_10TFD		0x1000	/* capable of 10BT full duplex */
	#define GMII_STATUS_10T			0x0800	/* capable of 10BT */

#define GMII_PHY_OUI				0x02	/* most of the OUI bits */
#define GMII_PHY_MODEL				0x03	/* model/rev bits, and rest of OUI */
#define GMII_PHY_ANAR				0x04	/* AN advertisement reg */
	/* Bit definitions: Auto-Negotiation Advertisement */
	#define GMII_ANAR_ASYM_PAUSE	0x0800	/* support asymetric pause */
	#define GMII_ANAR_PAUSE			0x0400	/* support pause packets */
	#define GMII_ANAR_100T4			0x0200	/* support 100BT4 */
	#define GMII_ANAR_100TXFD		0x0100	/* support 100BTX full duplex */
	#define GMII_ANAR_100TX			0x0080	/* support 100BTX half duplex */
	#define GMII_ANAR_10TFD			0x0040	/* support 10BT full duplex */
	#define GMII_ANAR_10T			0x0020	/* support 10BT half duplex */
	#define GMII_SELECTOR_FIELD		0x001F	/* selector field. */

#define GMII_PHY_ANLPAR				0x05	/* AN Link Partner */
	/* Bit definitions: Auto-Negotiation Link Partner Ability */
	#define GMII_ANLPAR_100T4		0x0200	/* support 100BT4 */
	#define GMII_ANLPAR_100TXFD		0x0100	/* support 100BTX full duplex */
	#define GMII_ANLPAR_100TX		0x0080	/* support 100BTX half duplex */
	#define GMII_ANLPAR_10TFD		0x0040	/* support 10BT full duplex */
	#define GMII_ANLPAR_10T			0x0020	/* support 10BT half duplex */
	#define GMII_ANLPAR_PAUSE		0x0400	/* support pause packets */
	#define GMII_ANLPAR_ASYM_PAUSE		0x0800	/* support asymetric pause */
	#define GMII_ANLPAR_ACK			0x4000	/* means LCB was successfully rx'd */
	#define GMII_SELECTOR_8023		0x0001

#define GMII_PHY_ANER				0x06		/* AN expansion reg */
#define GMII_PHY_1000BT_CONTROL			0x09	/* control reg for 1000BT */
#define GMII_PHY_1000BT_STATUS			0x0A	/* status reg for 1000BT */

#define GMII_PHY_MACR				0x0D
#define GMII_PHY_MAADR				0x0E

#define GMII_PHY_PHYSR				0x11	/* PHY specific status register */
	#define GMII_PHY_PHYSR_SMASK	0xc000
	#define GMII_PHY_PHYSR_GIGA		0x8000
	#define GMII_PHY_PHYSR_100		0x4000
	#define GMII_PHY_PHYSR_FULL		0x2000
	#define GMII_PHY_PHYSR_LINK		0x400

/* Bit definitions: 1000BaseT AUX Control */
#define GMII_1000_AUX_CTRL_MASTER_SLAVE		0x1000
#define GMII_1000_AUX_CTRL_FD_CAPABLE		0x0200	/* full duplex capable */
#define GMII_1000_AUX_CTRL_HD_CAPABLE		0x0100	/* half duplex capable */

/* Bit definitions: 1000BaseT AUX Status */
#define GMII_1000_AUX_STATUS_FD_CAPABLE		0x0800	/* full duplex capable */
#define GMII_1000_AUX_STATUS_HD_CAPABLE		0x0400	/* half duplex capable */

/* Cicada MII Registers */
#define GMII_AUX_CTRL_STATUS			0x1C
#define GMII_AUX_ANEG_CPLT			0x8000
#define GMII_AUX_FDX				0x0020
#define GMII_AUX_SPEED_1000			0x0010
#define GMII_AUX_SPEED_100			0x0008

#define GMII_LED_ACTIVE				0x1a
	#define GMII_LED_ACTIVE_MASK		0xff8f
	#define GMII_LED0_ACTIVE		(1 << 4)
	#define GMII_LED1_ACTIVE		(1 << 5)
	#define GMII_LED2_ACTIVE		(1 << 6)

#define GMII_LED_LINK				0x1c
	#define GMII_LED_LINK_MASK		0xf888
	#define GMII_LED0_LINK_10		(1 << 0)
	#define GMII_LED0_LINK_100		(1 << 1)
	#define GMII_LED0_LINK_1000		(1 << 2)
	#define GMII_LED1_LINK_10		(1 << 4)
	#define GMII_LED1_LINK_100		(1 << 5)
	#define GMII_LED1_LINK_1000		(1 << 6)
	#define GMII_LED2_LINK_10		(1 << 8)
	#define GMII_LED2_LINK_100		(1 << 9)
	#define GMII_LED2_LINK_1000		(1 << 10)

	#define	LED_VALID	(1 << 15) /* UA2 LED Setting */

	#define	LED0_ACTIVE	(1 << 0)
	#define	LED0_LINK_10	(1 << 1)
	#define	LED0_LINK_100	(1 << 2)
	#define	LED0_LINK_1000	(1 << 3)
	#define	LED0_FD		(1 << 4)
	#define LED0_USB3_MASK	0x001f

	#define	LED1_ACTIVE	(1 << 5)
	#define	LED1_LINK_10	(1 << 6)
	#define	LED1_LINK_100	(1 << 7)
	#define	LED1_LINK_1000	(1 << 8)
	#define	LED1_FD		(1 << 9)
	#define LED1_USB3_MASK	0x03e0

	#define	LED2_ACTIVE	(1 << 10)
	#define	LED2_LINK_1000	(1 << 13)
	#define	LED2_LINK_100	(1 << 12)
	#define	LED2_LINK_10	(1 << 11)
	#define	LED2_FD		(1 << 14)
	#define LED2_USB3_MASK	0x7c00

#define GMII_PHYPAGE				0x1e

#define GMII_PHY_PAGE_SELECT			0x1f
	#define GMII_PHY_PAGE_SELECT_EXT	0x0007
	#define GMII_PHY_PAGE_SELECT_PAGE0	0X0000
	#define GMII_PHY_PAGE_SELECT_PAGE1	0X0001
	#define GMII_PHY_PAGE_SELECT_PAGE2	0X0002
	#define GMII_PHY_PAGE_SELECT_PAGE3	0X0003
	#define GMII_PHY_PAGE_SELECT_PAGE4	0X0004
	#define GMII_PHY_PAGE_SELECT_PAGE5	0X0005
	#define GMII_PHY_PAGE_SELECT_PAGE6	0X0006

enum ax_driver_flags {
	AX_UNPLUG = 0,
	AX_ENABLE,
	AX_LINK_CHG,
	AX_SELECTIVE_SUSPEND,
	AX_SCHEDULE_NAPI,
};

enum ax_chip_mode {
	AX_CHIP_AX88179 = 1,
	AX_CHIP_AX88179A,
	AX_CHIP_AX88772D,
	AX_CHIP_AX88279,
};

enum ax_chip_version {
	AX_VERSION_INVALID		= 0,
	AX_VERSION_AX88179		= 4,
	AX_VERSION_AX88179A_772D	= 6,
	AX_VERSION_AX88279		= 7,
};

struct ax_device;

struct rx_desc {
	struct list_head list;
	struct urb *urb;
	struct ax_device *context;
	void *buffer;
	void *head;
};

enum __ax_tx_flags {
	AX_TX_NONE = 0,
	AX_TX_TIMESTAMPS = 1,
};

struct tx_desc {
	struct list_head list;
	struct urb *urb;
	struct ax_device *context;
	void *buffer;
	void *head;
	u32 skb_num;
	u32 skb_len;
	unsigned long flags;
};

struct ax_bulkin_setting {
	u8 custom;
	u8 bulkin_setting[5];
};

enum ax_ether_link_speed {
	ETHER_LINK_NONE	= 0,
	ETHER_LINK_10	= 1,
	ETHER_LINK_100	= 2,
	ETHER_LINK_1000	= 3,
	ETHER_LINK_2500	= 4,
};

struct ax_ether_link {
	enum ax_ether_link_speed speed;
	bool full_duplex;
};

struct ax_device {
	unsigned long flags;
	struct usb_device *udev;
	struct usb_interface *intf;
	struct net_device *netdev;
	const struct driver_info *driver_info;
	struct napi_struct napi;
	struct urb *intr_urb;
	struct tx_desc tx_list[32];
	struct rx_desc rx_list[32];
	struct list_head rx_done, tx_free;
	struct sk_buff_head tx_queue, rx_queue;
	spinlock_t rx_lock, tx_lock;
	struct delayed_work schedule, hw_phy_work;
	struct mii_if_info mii;
	struct mutex control;

	int intr_interval;
	u32 saved_wolopts;
	u32 msg_enable;
	u32 tx_qlen;
	u16 speed;
	u8 *intr_buff;
	
	u8 tx_align_len;

	u8 link;
	u16 rxctl;
	u8 m_filter[8];

	u32 tx_casecade_size;
	u32 gso_max_size;
	u8 fw_version[3];

	struct ax_ether_link ether_link;
	int bEEE;

	struct ax_bulkin_setting bin_setting;
	bool tx_header_cksum;
	unsigned char chip_version;
	unsigned char sub_version;
	unsigned char fr_rversion;
	bool int_link_speed;
	u8 int_link_info;
};

struct driver_info {
	int	(*bind)(struct ax_device *);
	void	(*unbind)(struct ax_device *);
	int	(*hw_init)(struct ax_device *);
	int	(*stop)(struct ax_device *);
	int	(*rx_fixup)(struct ax_device *, struct rx_desc *, int, int);
	int	(*tx_fixup)(struct ax_device *, struct tx_desc *);
	int 	(*link_reset)(struct ax_device *);
	int 	(*system_suspend)(struct ax_device *);
	int 	(*system_resume)(struct ax_device *);

	unsigned long napi_weight;
	size_t	buf_rx_size;
	int	chip_mode;
};

struct skb_data {
	struct urb		*urb;
	struct ax_device	*dev;
	size_t			length;
};

struct ax_device_async_handle {
  	struct usb_ctrlrequest *req;
  	u8 m_filter[8];
  	u16 rxctl;
} __attribute__ ((packed));

struct ax_device_int_data {
	u8 res1;
	u8 link_info;
#define AX_INT_PPLS_LINK	(1 << 0)
#define AX_INT_SPLS_LINK	(1 << 1)
#define AX_INT_CABOFF_UNPLUG	(1 << 7)
	u8 link;
	__le16 res2;
	u8 status;
	__le16 res3;
} __attribute__ ((packed));

#define AX_RXHDR_L4_ERR		(1 << 8)
#define AX_RXHDR_L3_ERR		(1 << 9)

#define AX_RXHDR_L4_TYPE_ICMP		2
#define AX_RXHDR_L4_TYPE_IGMP		3
#define AX_RXHDR_L4_TYPE_TCMPV6	5

#define AX_RXHDR_L3_TYPE_IP		1
#define AX_RXHDR_L3_TYPE_IPV6		2

#define AX_RXHDR_L4_TYPE_MASK			0x1c
#define AX_RXHDR_L4_TYPE_UDP			4
#define AX_RXHDR_L4_TYPE_TCP			16
#define AX_RXHDR_L3CSUM_ERR			2
#define AX_RXHDR_L4CSUM_ERR			1
#define AX_RXHDR_CRC_ERR			0x20000000
#define AX_RXHDR_MII_ERR			0x40000000
#define AX_RXHDR_DROP_ERR			0x80000000

int ax_check_ether_addr(struct ax_device *axdev);
void ax_set_tx_qlen(struct ax_device *dev);

inline void *__rx_buf_align(void *data);
inline void *__tx_buf_align(void *data, u8 tx_align_len);
inline struct net_device_stats *ax_get_stats(struct net_device *dev);
void ax_write_bulk_callback(struct urb *urb);

void ax_get_drvinfo(struct net_device *net, struct ethtool_drvinfo *info);
#if LINUX_VERSION_CODE < KERNEL_VERSION(4, 10, 0)
int ax_get_settings(struct net_device *net, struct ethtool_cmd *cmd);
int ax_set_settings(struct net_device *net, struct ethtool_cmd *cmd);
#else
int ax_get_link_ksettings(struct net_device *netdev,
			  struct ethtool_link_ksettings *cmd);
int ax_set_link_ksettings(struct net_device *netdev,
			  const struct ethtool_link_ksettings *cmd);
#endif
u32 ax_get_msglevel(struct net_device *netdev);
void ax_set_msglevel(struct net_device *netdev, u32 value);
void ax_get_wol(struct net_device *net, struct ethtool_wolinfo *wolinfo);
int ax_set_wol(struct net_device *net, struct ethtool_wolinfo *wolinfo);

int ax_read_cmd
(struct ax_device *axdev, u8 cmd, u16 value, u16 index, u16 size, void *data,
int eflag);

int ax_write_cmd
(struct ax_device *axdev, u8 cmd, u16 value, u16 index, u16 size, void *data);

int ax_read_cmd_nopm
(struct ax_device *axdev, u8 cmd, u16 value, u16 index, u16 size, void *data,
int eflag);

int ax_write_cmd_nopm
(struct ax_device *axdev, u8 cmd, u16 value, u16 index, u16 size, void *data);

int ax_write_cmd_async
(struct ax_device *axdev, u8 cmd, u16 value, u16 index, u16 size, void *data);

int ax_mdio_read(struct net_device *netdev, int phy_id, int reg);
void ax_mdio_write(struct net_device *netdev, int phy_id, int reg, int val);


int ax_usb_command(struct ax_device *axdev, AX_IOCTL_COMMAND *info);
#endif /* __ASIX_MAIN_H */
