#ifndef __ASIX_COMMON_H
#define __ASIX_COMMON_H

#include <linux/version.h>

//#define AX_DRIVER_LOOKBACK

#define USB_VENDOR_ID_ASIX	0x0B95

#define AX_DEVICE_ID_179X	0x1790
#define AX_BCDDEVICE_ID_179	0x0100
#define AX_BCDDEVICE_ID_179A	0x0200
#define AX_DEVICE_ID_178A	0x178A
#define AX_BCDDEVICE_ID_178A	0x0100
#define AX_DEVICE_ID_772D	AX_DEVICE_ID_179X
#define AX_BCDDEVICE_ID_772D	0x0300
#define AX_BCDDEVICE_ID_279	0x0400

#define AX_DRIVER_STRING_179_178A	\
				"ASIX AX88179_178A USB Ethernet Controller"
#define AX_DRIVER_STRING_179A_772D	\
				"ASIX AX88279_179A_772D USB Ethernet Controller"

#define DRIVER_VERSION		"0.0.1"
#define DRIVER_AUTHOR		"ASIX"
#define DRIVER_DESC		"ASIX USB Ethernet Controller"
#define MODULENAME		"ax_usb_nic"

#define PRINT_VERSION(axdev, str) \
	printk("%s %s (%d.%d.%d_%d.%d)", \
		str, DRIVER_VERSION, \
		axdev->fw_version[0], \
		axdev->fw_version[1], \
		axdev->fw_version[2], \
		axdev->chip_version, \
		axdev->sub_version);

#define AX_MCAST_FILTER_SIZE		8
#define AX_MAX_MCAST			64

/* ASIX USB Vendor Command */
#define AX_ACCESS_MAC			0x01
#define AX_ACCESS_PHY			0x02
#define AX_ACCESS_WAKEUP		0x03
#define AX_ACCESS_EEPROM		0x04
#define AX_ACCESS_EFUSE			0x05
#define AX_RELOAD_EEPROM_EFUSE		0x06
#define AX_RELOAD_FLASH_EFUSE		0x06
#define AX_FW_MODE			0x08
	#define AX_FW_MODE_179A		0x0001
#define AX_WRITE_EFUSE_EN		0x09
#define AX_WRITE_EFUSE_DIS		0x0A
#define AX_ACCESS_MFAB			0x10
#define AX_PHY_POLLING			0x90

/* ASIX MAC Register */
#define PHYSICAL_LINK_STATUS		0x02
	#define	AX_USB_SS		0x04
	#define	AX_USB_HS		0x02
	#define	AX_USB_FS		0x01

#define GENERAL_STATUS			0x03
	#define	AX_SECLD		0x04

#define AX_CHIP_STATUS			0x05
	#define AX_CHIP_CODE_MASK	0x70

#define AX_SROM_ADDR			0x07
#define AX_SROM_CMD			0x0a
	#define EEP_RD			0x04
	#define EEP_WR			0x08
	#define EEP_BUSY		0x10

#define AX_SROM_DATA_LOW		0x08
#define AX_SROM_DATA_HIGH		0x09

#define AX_RX_CTL			0x0b
#define AX_RX_CTL_HI			0x0c
	#define AX_RX_CTL_DROPCRCERR_HI		0x01
	#define AX_RX_CTL_DROPCRCERR		0x0100
	#define AX_RX_CTL_IPE			0x0200
	#define AX_RX_CTL_TXPADCRC		0x0400
	#define AX_RX_CTL_START		0x0080
	#define AX_RX_CTL_AP			0x0020
	#define AX_RX_CTL_AM			0x0010
	#define AX_RX_CTL_AB			0x0008
	#define AX_RX_CTL_HA8B			0x0004
	#define AX_RX_CTL_AMALL		0x0002
	#define AX_RX_CTL_PRO			0x0001
	#define AX_RX_CTL_STOP			0x0000

#define AX_NODE_ID			0x10
#define AX_MULTI_FILTER_ARRY		0x16

#define AX_MEDIUM_STATUS_MODE			0x22
	#define AX_MEDIUM_GIGAMODE		0x0001
	#define AX_MEDIUM_FULL_DUPLEX		0x0002
	#define AX_MEDIUM_RXFLOW_CTRLEN		0x0010
	#define AX_MEDIUM_TXFLOW_CTRLEN		0x0020
	#define AX_MEDIUM_RECEIVE_EN		0x0100
	#define AX_MEDIUM_PS			0x0200
	#define AX_MEDIUM_JUMBO_EN		0x8040

#define AX_MONITOR_MODE			0x24
	#define AX_MONITOR_MODE_RWLC		0x02
	#define AX_MONITOR_MODE_RWMP		0x04
	#define AX_MONITOR_MODE_RWWF		0x08
	#define AX_MONITOR_MODE_RW_FLAG		0x10
	#define AX_MONITOR_MODE_PMEPOL		0x20
	#define AX_MONITOR_MODE_PMETYPE		0x40

#define AX_GPIO_CTRL			0x25
	#define AX_GPIO_CTRL_GPIO3EN		0x80
	#define AX_GPIO_CTRL_GPIO2EN		0x40
	#define AX_GPIO_CTRL_GPIO1EN		0x20

#define AX_PHYPWR_RSTCTL		0x26
	#define AX_PHYPWR_RSTCTL_BZ		0x0010
	#define AX_PHYPWR_RSTCTL_IPRL		0x0020
	#define AX_PHYPWR_RSTCTL_AUTODETACH	0x1000

#define AX_RX_BULKIN_QCTRL		0x2e
	#define AX_RX_BULKIN_QCTRL_TIME		0x01
	#define AX_RX_BULKIN_QCTRL_IFG		0x02
	#define AX_RX_BULKIN_QCTRL_SIZE		0x04

#define AX_RX_BULKIN_QTIMR_LOW		0x2f
#define AX_RX_BULKIN_QTIMR_HIGH			0x30
#define AX_RX_BULKIN_QSIZE			0x31
#define AX_RX_BULKIN_QIFG			0x32

#define AX_CLK_SELECT			0x33
	#define AX_CLK_SELECT_BCS		0x01
	#define AX_CLK_SELECT_ACS		0x02
	#define AX_CLK_SELECT_ACSREQ		0x10
	#define AX_CLK_SELECT_ULR		0x08

#define AX_RXCOE_CTL			0x34
	#define AX_RXCOE_IP			0x01
	#define AX_RXCOE_TCP			0x02
	#define AX_RXCOE_UDP			0x04
	#define AX_RXCOE_ICMP			0x08
	#define AX_RXCOE_IGMP			0x10
	#define AX_RXCOE_TCPV6			0x20
	#define AX_RXCOE_UDPV6			0x40
	#define AX_RXCOE_ICMV6			0x80

#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 22)
	#define AX_RXCOE_DEF_CSUM	(AX_RXCOE_IP	| AX_RXCOE_TCP  | \
					 AX_RXCOE_UDP	| AX_RXCOE_ICMV6 | \
					 AX_RXCOE_TCPV6	| AX_RXCOE_UDPV6)
#else
	#define AX_RXCOE_DEF_CSUM	(AX_RXCOE_IP	| AX_RXCOE_TCP | \
					 AX_RXCOE_UDP)
#endif

#define AX_TXCOE_CTL			0x35
	#define AX_TXCOE_IP			0x01
	#define AX_TXCOE_TCP			0x02
	#define AX_TXCOE_UDP			0x04
	#define AX_TXCOE_ICMP			0x08
	#define AX_TXCOE_IGMP			0x10
	#define AX_TXCOE_TCPV6			0x20
	#define AX_TXCOE_UDPV6			0x40
	#define AX_TXCOE_ICMV6			0x80
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 22)
	#define AX_TXCOE_DEF_CSUM	(AX_TXCOE_TCP   | AX_TXCOE_UDP | \
					 AX_TXCOE_TCPV6 | AX_TXCOE_UDPV6)
#else
	#define AX_TXCOE_DEF_CSUM	(AX_TXCOE_TCP	| AX_TXCOE_UDP)
#endif


#define AX_PAUSE_WATERLVL_HIGH	0x54
#define AX_PAUSE_WATERLVL_LOW		0x55

#define AX_RX_FREE_BUF_LOW		0x57

/* CHANGE NETWORK INTERFACE WAY */
// DEFAULT_SCAN   : scan "eth0" - "eth255"
// INTERFACE_SCAN : scan all available network interfaces
#define NET_INTERFACE	DEFAULT_SCAN
#define DEFAULT_SCAN	0x00
#define INTERFACE_SCAN	0x01

/* NAMING CONSTANT DECLARATIONS */
#define AX88179_SIGNATURE	"AX88179_178A"
#define AX88179_DRV_NAME	"AX88179_178A"

#define AX88179A_SIGNATURE	"AX88179A_772D"
#define AX88179A_DRV_NAME	"AX88179A_772D"

/* ioctl Command Definition */
#define AX_PRIVATE		SIOCDEVPRIVATE

/* private Command Definition */
#define AX_SIGNATURE			0
#define AX_USB_COMMAND			1
// AX88179_178a
#define AX88179_READ_EEPROM		2
#define AX88179_WRITE_EEPROM		3
// AX88179a_772d
#define AX88179A_READ_VERSION		2
#define AX88179A_WRITE_FLASH		3
#define AX88179A_ROOT_2_ROM		4
#define AX88179A_ERASE_FLASH		5
#define AX88179A_SW_RESET		6
#define AX88179A_READ_FLASH		7
#define AX88179A_PROGRAM_EFUSE		8
#define AX88179A_DUMP_EFUSE		9

/* Flash Status */
#define ERR_FALSH_WRITE_EN		1
#define ERR_FALSH_WRITE_DIS		2
#define ERR_FALSH_ERASE_ALL		3
#define ERR_FALSH_WRITE			4
#define ERR_FALSH_READ			5
#define ERR_EFUSE_READ			6
#define ERR_EFUSE_WRITE			6

/* USB Command Operation */
#define USB_READ_OPS			0
#define USB_WRITE_OPS			1

#define SCAN_DEV_MAX_RETRY		10

struct _ax_usb_command {
	unsigned char	ops;
	unsigned char	cmd;
	unsigned short	value;
	unsigned short	index;
	unsigned short	size;
	unsigned char	*data;
};

struct _ax88179a_flash {
	int status;
	int length;
	int offset;
	unsigned char *buf;
};

struct _ax88179a_version {
	unsigned char version[16];
};

typedef struct _AX_IOCTL_COMMAND {
	unsigned short	ioctl_cmd;
	unsigned char	sig[16];
	unsigned char	type;
	unsigned short *buf;
	unsigned short size;
	unsigned char delay;
	union {
		struct _ax88179a_flash		flash;
		struct _ax88179a_version	version;
		struct _ax_usb_command		usb_cmd;
	};
} AX_IOCTL_COMMAND;

#define SWAP_32(val)	(((val >> 24) & 0x000000FF) | \
			 ((val >>  8) & 0x0000FF00) | \
			 ((val <<  8) & 0x00FF0000) | \
			 ((val << 24) & 0xFF000000))
struct ax_device;
typedef int (*IOCTRL_TABLE)(struct ax_device *axdev, AX_IOCTL_COMMAND *info);

#endif /* __ASIX_COMMON_H */
